/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import cz.insophy.inplan.sdgraph.SdgEsaNode;
import cz.insophy.inplan.sdgraph.SdgGarNode;
import cz.insophy.inplan.sdgraph.SdgGorNode;
import cz.insophy.inplan.sdgraph.SdgNode;
import cz.insophy.inplan.sdgraph.SdgNodeVisitor;
import cz.insophy.inplan.sdgraph.SdgNodeVisitorAdapter;
import cz.insophy.inplan.sdgraph.SdgSrNode;
import cz.insophy.inplan.util.Localizer;

public enum MaterialSource {
    SUPPLY_REQUEST,
    STORE,
    PRODUCTION,
    COMBINED,
    UNAVAILABLE,
    INCOMPL_SUPPLY_REQUEST,
    INCOMPL_STORE,
    INCOMPL_PRODUCTION,
    INCOMPL_COMBINED;

    private static SdgNodeVisitor<MaterialSource> SOURCE_VISITOR;

    public static MaterialSource fromNode(SdgNode node) {
        if (node == null) {
            return UNAVAILABLE;
        }
        return node.accept(SOURCE_VISITOR);
    }

    public static MaterialSource combineSources(MaterialSource source1, SdgNode node) {
        MaterialSource source2 = MaterialSource.fromNode(node);
        if (source1 == null || source1 == UNAVAILABLE) {
            return source2;
        }
        if (source1 == source2) {
            return source1;
        }
        return COMBINED;
    }

    public String toString() {
        switch (this) {
            case COMBINED: {
                return Localizer.getString("material_request_manager.columns.source.combined");
            }
            case PRODUCTION: {
                return Localizer.getString("material_request_manager.columns.source.production");
            }
            case STORE: {
                return Localizer.getString("material_request_manager.columns.source.store");
            }
            case SUPPLY_REQUEST: {
                return Localizer.getString("material_request_manager.columns.source.supply_request");
            }
            case UNAVAILABLE: {
                return Localizer.getString("material_request_manager.columns.source.unavailable");
            }
            case INCOMPL_COMBINED: {
                return Localizer.getString("material_request_manager.columns.source.incompl_combined");
            }
            case INCOMPL_PRODUCTION: {
                return Localizer.getString("material_request_manager.columns.source.incompl_production");
            }
            case INCOMPL_STORE: {
                return Localizer.getString("material_request_manager.columns.source.incompl_store");
            }
            case INCOMPL_SUPPLY_REQUEST: {
                return Localizer.getString("material_request_manager.columns.source.incompl_supply_request");
            }
        }
        throw new IllegalArgumentException();
    }

    static {
        SOURCE_VISITOR = new SdgNodeVisitorAdapter<MaterialSource>(){

            @Override
            public MaterialSource visit(SdgSrNode node) {
                return SUPPLY_REQUEST;
            }

            @Override
            public MaterialSource visit(SdgGorNode node) {
                return PRODUCTION;
            }

            @Override
            public MaterialSource visit(SdgGarNode node) {
                return PRODUCTION;
            }

            @Override
            public MaterialSource visit(SdgEsaNode node) {
                return STORE;
            }
        };
    }
}

